/*
 * Decompiled with CFR 0.152.
 */
package com.biz.security.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.biz.security.util.FileUtil;
import java.io.IOException;
import java.util.Base64;
import java.util.Date;
import java.util.Properties;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class JWTUtil {
    Algorithm algorithm = null;
    String issuer = null;
    Long expiry = null;
    Long notBefore = null;
    String secret = null;
    String subject = null;

    public JWTUtil() {
        Properties properties = null;
        try {
            properties = FileUtil.getProperties();
            this.secret = properties.getProperty("auth.jwt.secret");
            this.issuer = properties.getProperty("auth.jwt.issuer");
            this.subject = properties.getProperty("auth.jwt.subject");
            this.expiry = Long.parseLong(properties.getProperty("auth.jwt.expiry"));
            this.notBefore = Long.parseLong(properties.getProperty("auth.jwt.not.before"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.algorithm = Algorithm.HMAC256((String)this.secret);
    }

    public static void main(String[] args) {
        JWTUtil jwtUtil = new JWTUtil();
        try {
            jwtUtil.verifyToken("eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOiJBdXRoZW50aWNhdGlvbiIsInByaXZpbGVnZXMiOlsiU1VQRVJBRE1JTiIsIkFETUlOIl0sIm5iZiI6MTY4MDUyNDM4NSwiaXNzIjoiQml6c2Vuc29ycyIsImV4cCI6MTY4ODM0MzU4MCwidXNlcklkIjoic291bWFkZWVwQGdtYWlsLmNvbSIsImlhdCI6MTY4MDUyNDM4MCwianRpIjoiNzIzYmUwMjEtYmQzMC00NDdlLThhYTEtOThiNTEyZWFmY2VjIn0.H8gAofn5VXNQWo1XSu-vxXCuS0HgDY3CYotXDuJjNKQ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String createToken(String userId, String[] privileges) {
        String jwtToken = JWT.create().withIssuer(this.issuer).withSubject(this.subject).withClaim("userId", userId).withArrayClaim("privileges", privileges).withIssuedAt(new Date()).withExpiresAt(new Date(System.currentTimeMillis() + this.expiry)).withJWTId(UUID.randomUUID().toString()).withNotBefore(new Date(System.currentTimeMillis() + this.notBefore)).sign(this.algorithm);
        return jwtToken;
    }

    public Claim verifyToken(String jwtToken) throws Exception {
        JWTVerifier verifier = JWT.require((Algorithm)this.algorithm).withIssuer(this.issuer).build();
        try {
            DecodedJWT decodedJWT = verifier.verify(jwtToken);
            return decodedJWT.getClaim("privileges");
        }
        catch (JWTVerificationException e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    public Claim getClaim(String jwtToken, String claimName) throws Exception {
        JWTVerifier verifier = JWT.require((Algorithm)this.algorithm).withIssuer(this.issuer).build();
        try {
            DecodedJWT decodedJWT = verifier.verify(jwtToken);
            return decodedJWT.getClaim(claimName);
        }
        catch (JWTVerificationException e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    public static boolean calcHmacSha256(byte[] secretKey, byte[] message, String wcSignature) {
        byte[] hmacSha256 = null;
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey, "HmacSHA256");
            mac.init(secretKeySpec);
            hmacSha256 = mac.doFinal(message);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate hmac-sha256", e);
        }
        String encodedString = Base64.getEncoder().encodeToString(hmacSha256);
        if (encodedString.equals(wcSignature)) {
            System.out.println("Signatures match");
            return true;
        }
        return false;
    }
}

