/*
 * Decompiled with CFR 0.152.
 */
package com.biz.security.util;

import com.biz.security.db.User;
import com.biz.security.util.DBUtil;
import com.biz.security.util.FileUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import javax.mail.Authenticator;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.SimpleEmail;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailUtil {
    private static final Logger log = LoggerFactory.getLogger(EmailUtil.class);

    public static void sendRegistrationEmail(User user) throws Exception {
        Properties props = FileUtil.getProperties();
        log.debug("HOST " + props.getProperty("email.host") + " PORT " + props.getProperty("email.port") + " Username [" + props.getProperty("email.username") + "]");
        String username = props.getProperty("email.username");
        String password = props.getProperty("email.password");
        String template = props.getProperty("registration.template");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", user.getFirstName());
        params.put("activationLink", props.getProperty("activation.link"));
        params.put("userId", user.getId());
        params.put("from", props.getProperty("sales.from"));
        String result = StringSubstitutor.replace((Object)template, params, (String)"${", (String)"}");
        ArrayList<InternetAddress> replyTo = new ArrayList<InternetAddress>();
        InternetAddress address = new InternetAddress();
        address.setAddress(props.getProperty("email.reply.to"));
        address.setPersonal(props.getProperty("email.reply.to.name"));
        replyTo.add(address);
        try {
            SimpleEmail email = new SimpleEmail();
            email.setHostName(props.getProperty("email.host"));
            email.setSmtpPort(Integer.parseInt(props.getProperty("email.port")));
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(username, password));
            email.setFrom(props.getProperty("email.from"));
            email.setSubject("Registration Request");
            email.setMsg(result);
            email.addTo(user.getEmailId());
            email.setSSLCheckServerIdentity(true);
            email.setStartTLSRequired(true);
            email.setSSLOnConnect(true);
            email.setDebug(true);
            email.setReplyTo(replyTo);
            email.send();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public static String sendPin(String emailId, String pin) throws Exception {
        Properties props = FileUtil.getProperties();
        User user = DBUtil.getUser(emailId);
        String template = props.getProperty("change.password.pin.template");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", user.getFirstName());
        params.put("pin", pin);
        params.put("from", props.getProperty("sales.from"));
        String result = StringSubstitutor.replace((Object)template, params, (String)"${", (String)"}");
        ArrayList<InternetAddress> replyTo = new ArrayList<InternetAddress>();
        InternetAddress address = new InternetAddress();
        address.setAddress(props.getProperty("email.reply.to"));
        address.setPersonal(props.getProperty("email.reply.to.name"));
        replyTo.add(address);
        try {
            SimpleEmail email = new SimpleEmail();
            email.setHostName(props.getProperty("email.host"));
            email.setSmtpPort(Integer.parseInt(props.getProperty("email.port")));
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(props.getProperty("email.username"), props.getProperty("email.password")));
            email.setFrom(props.getProperty("email.from"));
            email.setSubject("Pin Request");
            email.setMsg(result);
            email.addTo(user.getEmailId());
            email.setReplyTo(replyTo);
            email.setSSLCheckServerIdentity(true);
            email.setStartTLSRequired(true);
            email.setSSLOnConnect(true);
            email.setDebug(true);
            email.send();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        return pin;
    }

    public static String emailPin() {
        Random rand = new Random();
        String pin = String.format("%04d", rand.nextInt(10000));
        return pin;
    }
}

