/*
 * Decompiled with CFR 0.152.
 */
package com.biz.security.util;

import com.biz.security.db.Company;
import com.biz.security.db.Org;
import com.biz.security.db.OrgDetail;
import com.biz.security.db.PartnerType;
import com.biz.security.db.Privilege;
import com.biz.security.db.Role;
import com.biz.security.db.RolePrivilege;
import com.biz.security.db.RolePrivilegeId;
import com.biz.security.db.User;
import com.biz.security.db.UserManager;
import com.biz.security.db.UserManagerId;
import com.biz.security.db.UserRole;
import com.biz.security.db.UserRoleId;
import com.biz.security.exception.AppException;
import com.biz.security.model.AppUser;
import com.biz.security.model.DBStatsModel;
import com.biz.security.model.OrgDetailModel;
import com.biz.security.model.OrgModel;
import com.biz.security.model.OrgUserDBModel;
import com.biz.security.model.PasswordRequest;
import com.biz.security.model.RolePrivilegeModel;
import com.biz.security.model.UpdateRolePrivilegeModel;
import com.biz.security.model.UserModel;
import com.biz.security.util.EmailUtil;
import com.biz.security.util.FileUtil;
import com.biz.security.util.HibernateUtil;
import com.biz.security.util.JWTUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.NoResultException;
import org.apache.commons.text.StringSubstitutor;
import org.glassfish.jersey.media.multipart.BodyPartEntity;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.stat.Statistics;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class DBUtil {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static OrgModel getOrg(AppUser user, String orgId) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        OrgModel orgModel = new OrgModel();
        try (Session session = sf.openSession();){
            try {
                Org org = (Org)session.get(Org.class, (Serializable)((Object)orgId));
                orgModel.setAddLine1(org.getAddLine1());
                orgModel.setAddLine2(org.getAddLine2());
                orgModel.setCity(org.getCity());
                orgModel.setContactNos(org.getContactNos());
                orgModel.setCountry(org.getCountry());
                orgModel.setDefaultRole(org.getDefaultRole());
                orgModel.setEmail(org.getEmail());
                orgModel.setFirstName(org.getFirstName());
                orgModel.setId(org.getId());
                orgModel.setLandingPage("");
                orgModel.setLastName(org.getLastName());
                orgModel.setMobileNumber(org.getMobilePhone());
                orgModel.setName(org.getName());
                orgModel.setOrgDetails(org.getOrgDetails());
                orgModel.setPasswd("*****");
                orgModel.setRegistrationStatus(org.getRegistrationStatus());
                orgModel.setState(org.getState());
                orgModel.setSubType(org.getSubType());
                orgModel.setType(org.getType());
                orgModel.setUniqueId(0L);
                orgModel.setWebsite(org.getWebsite());
                orgModel.setWhatsappEnabled(org.getWhatsappEnabled());
                orgModel.setZipcode(org.getZipcode());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return orgModel;
    }

    public static AppUser login(String username, String password) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        User user = null;
        AppUser appUser = null;
        password = DBUtil.getMd5(password);
        try {
            try {
                String query = "from User u where (u.emailId =:username or u.mobilePhone =:username) and u.passwd =:password and u.inactive =:inactive";
                user = (User)session.createQuery(query).setParameter("username", (Object)username).setParameter("password", (Object)password).setParameter("inactive", (Object)false).getSingleResult();
                Set<UserRole> userRoles = user.getUserRoles();
                ArrayList<Integer> roleIds = new ArrayList<Integer>();
                for (UserRole userRole : userRoles) {
                    roleIds.add(userRole.getId().getRoleId());
                }
                String query0 = "from Role r where r.id in :roleIds and r.inactive =:inactive";
                List roles = session.createQuery(query0).setParameter("inactive", (Object)false).setParameter("roleIds", roleIds).list();
                String query1 = "from RolePrivilege rp where rp.id.roleId in :roleIds and rp.inactive =:inactive";
                List rolePrivileges = session.createQuery(query1).setParameter("inactive", (Object)false).setParameter("roleIds", roleIds).list();
                ArrayList<Integer> privilegeIds = new ArrayList<Integer>();
                for (RolePrivilege rp : rolePrivileges) {
                    privilegeIds.add(rp.getId().getPrivilegeId());
                }
                String query2 = "from Privilege p where p.id in :privilegeIds and p.inactive =:inactive ORDER BY p.privilege ASC";
                List privileges = session.createQuery(query2).setParameter("inactive", (Object)false).setParameter("privilegeIds", privilegeIds).list();
                HashSet<String> privs = new HashSet<String>(0);
                for (Privilege p : privileges) {
                    privs.add(p.getPrivilege());
                }
                HashSet<String> roleNames = new HashSet<String>(0);
                for (Role p : roles) {
                    roleNames.add(p.getRoleName());
                }
                JWTUtil jwtUtil = new JWTUtil();
                String[] array = privs.toArray(new String[privileges.size()]);
                String jwtToken = jwtUtil.createToken(user.getEmailId(), array);
                appUser = new AppUser(user.getId(), user.getEmailId(), user.getFirstName(), user.getLastName(), user.getUserName(), user.getMobilePhone(), user.getLandline(), user.getPhotoPath(), user.getUserType(), user.isInactive(), user.getColor(), user.getCreatedBy(), user.getDateCreated(), user.getAddress(), user.getCity(), user.getState(), user.getCountry(), user.getZip(), user.getProfilePic(), jwtToken, privs, roleNames, user.getOrgId(), user.getLandingPage());
            }
            catch (NoResultException ex) {
                ex.printStackTrace();
                throw new Exception("Please check your username or password!");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return appUser;
    }

    public static void updateRegistrationToken(AppUser appUser, String registrationToken) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        try {
            try {
                User user = (User)session.get(User.class, (Serializable)((Object)appUser.getId()));
                user.setRegistrationToken(registrationToken);
                session.update((Object)user);
                tr.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static AppUser getDefaultUser() throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Object user = null;
        Object appUser = null;
        try {
            Org org = (Org)session.createQuery("from Org o where o.defaultOrg = true", Org.class).getSingleResult();
            String defaultUserEmailId = org.getEmail();
            AppUser appUser2 = DBUtil.getAppUser(defaultUserEmailId);
            return appUser2;
        }
        catch (NoResultException ex) {
            ex.printStackTrace();
            throw new Exception("Please check your username or password!");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static Org getDefaultOrg() throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        try (Session session = sf.openSession();){
            Org org;
            Org org2 = org = (Org)session.createQuery("from Org o where o.defaultOrg = true", Org.class).getSingleResult();
            return org2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<User> getUserListByRole(String orgId, int roleId) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        List users = null;
        try (Session session = sf.openSession();){
            try {
                users = session.createNativeQuery("select * from `user` u where u.org_id =:orgId and u.id in (select ur.user_id from user_role ur where ur.role_id=:roleId)", User.class).setParameter("orgId", (Object)orgId).setParameter("roleId", (Object)roleId).list();
                return users;
            }
            catch (NoResultException ex) {
                ex.printStackTrace();
                if (session == null) return users;
                session.close();
                return users;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (session == null) return users;
                session.close();
                return users;
            }
        }
    }

    public static AppUser getAppUser(String email) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        User user = null;
        AppUser appUser = null;
        try {
            try {
                String query = "from User u where (u.emailId =:username or u.mobilePhone =:username) and u.inactive =:inactive";
                user = (User)session.createQuery(query).setParameter("username", (Object)email).setParameter("inactive", (Object)false).getSingleResult();
                Set<UserRole> userRoles = user.getUserRoles();
                ArrayList<Integer> roleIds = new ArrayList<Integer>();
                for (UserRole userRole : userRoles) {
                    roleIds.add(userRole.getId().getRoleId());
                }
                String query0 = "from Role r where r.id in :roleIds and r.inactive =:inactive";
                List roles = session.createQuery(query0).setParameter("inactive", (Object)false).setParameter("roleIds", roleIds).list();
                String query1 = "from RolePrivilege rp where rp.id.roleId in :roleIds and rp.inactive =:inactive";
                List rolePrivileges = session.createQuery(query1).setParameter("inactive", (Object)false).setParameter("roleIds", roleIds).list();
                ArrayList<Integer> privilegeIds = new ArrayList<Integer>();
                for (RolePrivilege rp : rolePrivileges) {
                    privilegeIds.add(rp.getId().getPrivilegeId());
                }
                String query2 = "from Privilege p where p.id in :privilegeIds and p.inactive =:inactive";
                List privileges = session.createQuery(query2).setParameter("inactive", (Object)false).setParameter("privilegeIds", privilegeIds).list();
                HashSet<String> privs = new HashSet<String>(0);
                for (Privilege p : privileges) {
                    privs.add(p.getPrivilege());
                }
                HashSet<String> roleNames = new HashSet<String>(0);
                for (Role p : roles) {
                    roleNames.add(p.getRoleName());
                }
                JWTUtil jwtUtil = new JWTUtil();
                String[] array = privs.toArray(new String[privileges.size()]);
                String jwtToken = jwtUtil.createToken(user.getEmailId(), array);
                appUser = new AppUser(user.getId(), user.getEmailId(), user.getFirstName(), user.getLastName(), user.getUserName(), user.getMobilePhone(), user.getLandline(), user.getPhotoPath(), user.getUserType(), user.isInactive(), user.getColor(), user.getCreatedBy(), user.getDateCreated(), user.getAddress(), user.getCity(), user.getState(), user.getCountry(), user.getZip(), user.getProfilePic(), jwtToken, privs, roleNames, user.getOrgId(), user.getLandingPage());
            }
            catch (NoResultException ex) {
                ex.printStackTrace();
                throw new Exception("Please check your username or password!");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return appUser;
    }

    public static void register(AppUser appUser, UserModel user) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        String orgId = null;
        String createdBy = "0";
        try {
            try {
                List u = session.createQuery("from User r where r.emailId = :emailId or r.mobilePhone = :mobilePhone or r.userName =:userName").setParameter("emailId", (Object)user.getEmailId()).setParameter("mobilePhone", (Object)user.getMobilePhone()).setParameter("userName", (Object)user.getUserName()).list();
                if (!u.isEmpty()) {
                    throw new AppException("You have already registered! Check your email, mobile number or username.");
                }
                if (appUser == null) {
                    Org org = (Org)session.createQuery("from Org o where o.primaryOrg = true", Org.class).getSingleResult();
                    orgId = org.getId();
                } else {
                    orgId = appUser.getOrgId();
                    createdBy = appUser.getId();
                }
                UUID uuid = UUID.randomUUID();
                User usr = new User();
                usr.setAddress(user.getAddress());
                usr.setCity(user.getCity());
                usr.setColor(user.getColor());
                usr.setCountry(user.getCountry());
                usr.setEmailId(user.getEmailId());
                usr.setFirstName(user.getFirstName());
                usr.setLastName(user.getLastName());
                usr.setLandline(user.getLandline());
                usr.setLoginTries(0);
                usr.setTries(0);
                usr.setMobilePhone(user.getMobilePhone());
                usr.setState(user.getState());
                usr.setSystemDefault(false);
                usr.setUserName(user.getUserName());
                usr.setZip(user.getZip());
                usr.setUserType(user.getUserType());
                usr.setDateCreated(new Date());
                usr.setId(uuid.toString());
                usr.setInactive(true);
                usr.setPasswd(DBUtil.getMd5(user.getPasswd()));
                usr.setOrgId(orgId);
                usr.setCreatedBy(createdBy);
                if (user.getLandingPage() != null && !user.getLandingPage().isEmpty()) {
                    usr.setLandingPage(user.getLandingPage());
                }
                if (appUser != null) {
                    UserManager userManager = new UserManager();
                    UserManagerId userManagerId = new UserManagerId();
                    userManagerId.setManagerId(appUser.getId());
                    userManagerId.setOrgId(appUser.getOrgId());
                    userManager.setUpdatedBy(appUser.getId());
                    userManager.setCreatedBy(appUser.getId());
                    userManagerId.setUserId(usr.getId());
                    userManager.setId(userManagerId);
                    userManager.setDateCreated(new Date());
                    userManager.setDateUpdated(new Date());
                    session.save((Object)userManager);
                }
                session.save((Object)usr);
                DBUtil.addUserRoles(usr, session);
                tr.commit();
                EmailUtil.sendRegistrationEmail(usr);
            }
            catch (Exception ex) {
                System.out.println("Regular exception " + ex.getClass().getName());
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static UserModel mobileRegister(UserModel user) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        String orgId = null;
        String createdBy = "0";
        try {
            List u = session.createQuery("from User r where r.emailId = :emailId or r.mobilePhone = :mobilePhone or r.userName =:userName").setParameter("emailId", (Object)user.getEmailId()).setParameter("mobilePhone", (Object)user.getMobilePhone()).setParameter("userName", (Object)user.getUserName()).list();
            if (!u.isEmpty()) {
                throw new AppException("You have already registered! Check your email, mobile number or username.");
            }
            Org org = (Org)session.createQuery("from Org o where o.primaryOrg = true", Org.class).getSingleResult();
            orgId = org.getId();
            UUID uuid = UUID.randomUUID();
            User usr = new User();
            usr.setAddress(user.getAddress());
            usr.setCity(user.getCity());
            usr.setColor(user.getColor());
            usr.setCountry(user.getCountry());
            usr.setEmailId(user.getEmailId());
            usr.setFirstName(user.getFirstName());
            usr.setLastName(user.getLastName());
            usr.setLandline(user.getLandline());
            usr.setLoginTries(0);
            usr.setTries(0);
            usr.setMobilePhone(user.getMobilePhone());
            usr.setState(user.getState());
            usr.setSystemDefault(false);
            usr.setUserName(user.getUserName());
            usr.setZip(user.getZip());
            usr.setUserType(user.getUserType());
            usr.setDateCreated(new Date());
            usr.setId(uuid.toString());
            usr.setInactive(true);
            usr.setPasswd(DBUtil.getMd5(user.getPasswd()));
            usr.setOrgId(orgId);
            usr.setCreatedBy(createdBy);
            if (user.getLandingPage() != null && !user.getLandingPage().isEmpty()) {
                usr.setLandingPage(user.getLandingPage());
            }
            UserManager userManager = new UserManager();
            UserManagerId userManagerId = new UserManagerId();
            userManagerId.setManagerId(createdBy);
            userManagerId.setOrgId(org.getId());
            userManagerId.setUserId(usr.getId());
            userManager.setCreatedBy(createdBy);
            userManager.setId(userManagerId);
            userManager.setUpdatedBy(createdBy);
            userManager.setDateCreated(new Date());
            userManager.setDateUpdated(new Date());
            session.save((Object)userManager);
            session.save((Object)usr);
            DBUtil.addUserRoles(usr, session);
            tr.commit();
            UserModel userModel = DBUtil.convertUserToUserModel(usr);
            return userModel;
        }
        catch (Exception ex) {
            System.out.println("Regular exception " + ex.getClass().getName());
            ex.printStackTrace();
            throw ex;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static void updateManager(AppUser appUser, UserManager userManager) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        try {
            try {
                userManager.setUpdatedBy(appUser.getId());
                userManager.setDateUpdated(new Date());
                session.update((Object)userManager);
                tr.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JSONObject object = new JSONObject();
                object.put((Object)"error", (Object)ex.getMessage());
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static void addManager(AppUser appUser, UserManager userManager) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        try {
            try {
                userManager.setUpdatedBy(appUser.getId());
                userManager.setDateUpdated(new Date());
                session.save((Object)userManager);
                tr.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JSONObject object = new JSONObject();
                object.put((Object)"error", (Object)ex.getMessage());
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static List<UserManager> getManagedUsers(AppUser appUser) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        ArrayList<UserManager> userManager = new ArrayList();
        try (Session session = sf.openSession();){
            try {
                userManager = session.createQuery("from  UserManager  um where um.id.managerId = :managerId", UserManager.class).setParameter("managerId", (Object)appUser.getId()).list();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JSONObject object = new JSONObject();
                object.put((Object)"error", (Object)ex.getMessage());
                throw ex;
            }
        }
        return userManager;
    }

    public static List<UserManager> getManagersForUser(String userId) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        ArrayList<UserManager> userManager = new ArrayList();
        try (Session session = sf.openSession();){
            try {
                userManager = session.createQuery("from  UserManager  um where um.id.userId = :userId", UserManager.class).setParameter("userId", (Object)userId).list();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JSONObject object = new JSONObject();
                object.put((Object)"error", (Object)ex.getMessage());
                throw ex;
            }
        }
        return userManager;
    }

    public static HashMap<String, String> getManagersForUserId(String userId) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        List userManagers = new ArrayList();
        HashMap<String, String> managerNames = new HashMap<String, String>();
        try {
            try {
                userManagers = session.createQuery("from  UserManager  um where um.id.userId = :userId", UserManager.class).setParameter("userId", (Object)userId).list();
                if (userManagers != null) {
                    for (UserManager um : userManagers) {
                        String managerId = um.getId().getManagerId();
                        String managerName = DBUtil.getUserDisplayName(managerId);
                        managerNames.put(managerId, managerName);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JSONObject object = new JSONObject();
                object.put((Object)"error", (Object)ex.getMessage());
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return managerNames;
    }

    public static List<UserModel> getUsersByManager(AppUser appUser) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        try (Session session = sf.openSession();){
            try {
                List userManagers = session.createQuery("from  UserManager  um where um.id.managerId = :managerId", UserManager.class).setParameter("managerId", (Object)appUser.getId()).list();
                ArrayList<String> ids = new ArrayList<String>();
                for (UserManager um : userManagers) {
                    ids.add(um.getId().getUserId());
                }
                List usrs = session.createQuery("from User u where u.id in :ids", User.class).setParameterList("ids", ids).list();
                for (User u : usrs) {
                    users.add(DBUtil.convertUserToUserModel(u));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JSONObject object = new JSONObject();
                object.put((Object)"error", (Object)ex.getMessage());
                throw ex;
            }
        }
        return users;
    }

    public static User addProfilePicture(AppUser user, List<FormDataBodyPart> multiPart) throws Exception {
        List<FormDataBodyPart> bodyParts = multiPart;
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        Date dt = new Date();
        User usr = null;
        try {
            try {
                Properties prop = FileUtil.getProperties();
                String pathName = prop.getProperty("file.path") + "images/";
                usr = (User)session.get(User.class, (Serializable)((Object)user.getId()));
                int i = 0;
                while (i < bodyParts.size()) {
                    BodyPartEntity bodyPartEntity = (BodyPartEntity)bodyParts.get(i).getEntity();
                    String fileName = bodyParts.get(i).getContentDisposition().getFileName();
                    DBUtil.saveFile(bodyPartEntity.getInputStream(), pathName + dt.getTime() + "_" + fileName);
                    String contentType = bodyParts.get(i).getMediaType().toString();
                    usr.setProfilePic(dt.getTime() + "_" + fileName);
                    session.update((Object)usr);
                    ++i;
                }
                tr.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JSONObject object = new JSONObject();
                object.put((Object)"error", (Object)ex.getMessage());
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return usr;
    }

    public static void addUserRoles(User user, Session session) throws Exception {
        try {
            String userType = user.getUserType();
            Object[] roleNames = userType.split(";");
            List roles = session.createQuery("from Role r where r.roleName in :roleNames").setParameterList("roleNames", roleNames).list();
            if (roles != null && roles.isEmpty()) {
                throw new AppException("The provided role " + user.getUserType() + " doesn't exist!");
            }
            for (Role r : roles) {
                UserRole ur = new UserRole();
                UserRoleId uri = new UserRoleId();
                uri.setRoleId(r.getId());
                uri.setUserId(user.getId());
                ur.setId(uri);
                ur.setDateCreated(new Date());
                ur.setCreatedBy(user.getId());
                ur.setInactive(false);
                ur.setSystemDefault(false);
                ur.setUser(user);
                session.save((Object)ur);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public static String addUserRoles(AppUser appUser, List<Integer> roleIds, String userId) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        String status = "Role(s) have been added";
        try {
            try {
                User user = DBUtil.getUserById(userId);
                List rolesToAdd = session.createQuery("Select r from Role r where r.id in :roleIds and r.inactive = false and r.systemDefault = :defaultFlag and not exists ( select ur from UserRole ur where r.id = ur.id.roleId and ur.id.userId = :userId)").setParameterList("roleIds", roleIds).setParameter("userId", (Object)userId).setParameter("defaultFlag", (Object)false).list();
                if (rolesToAdd.isEmpty()) {
                    status = "Nothing to add. Either the role(s) are already present or the role(s) provided can't be added.";
                }
                for (Role r : rolesToAdd) {
                    System.out.println("Adding role " + r.getRoleName());
                    UserRole ur = new UserRole();
                    UserRoleId uri = new UserRoleId();
                    uri.setRoleId(r.getId());
                    uri.setUserId(user.getId());
                    ur.setId(uri);
                    ur.setDateCreated(new Date());
                    ur.setCreatedBy(appUser.getId());
                    ur.setInactive(false);
                    ur.setSystemDefault(false);
                    ur.setUser(user);
                    session.saveOrUpdate((Object)ur);
                }
                tr.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return status;
    }

    public static List<Role> getRoles() {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        ArrayList<Role> roles = new ArrayList();
        try (Session session = sf.openSession();){
            try {
                roles = session.createQuery("from Role r where r.systemDefault = true ORDER BY r.roleName asc").list();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return roles;
    }

    public static List<Role> getOrgRoles(AppUser appUser) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Org org = (Org)session.get(Org.class, (Serializable)((Object)appUser.getOrgId()));
        ArrayList<Role> roles = new ArrayList();
        try {
            try {
                roles = session.createQuery("from Role r where r.systemDefault = false and (r.orgId =:orgId or r.orgType =:type)", Role.class).setParameter("type", (Object)org.getType()).setParameter("orgId", (Object)appUser.getOrgId()).list();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return roles;
    }

    public static List<Role> getUserRoles(String userId) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        User usr = (User)session.get(User.class, (Serializable)((Object)userId));
        ArrayList<Role> roles = new ArrayList();
        JSONArray response = new JSONArray();
        try {
            try {
                roles = session.createQuery("select r from Role r, UserRole ur where r.systemDefault = false and r.id = ur.id.roleId and ur.id.userId =:userId", Role.class).setParameter("userId", (Object)userId).list();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return roles;
    }

    public static Role getApplicationRole(String roleId) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Role role = null;
        try (Session session = sf.openSession();){
            try {
                role = (Role)session.get(Role.class, (Serializable)((Object)roleId));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return role;
    }

    public static String deleteUserRoles(AppUser appUser, List<Integer> roleIds, String userId) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        String status = "Role(s) deleted.";
        try {
            try {
                User user = DBUtil.getUserById(userId);
                List rolesToDelete = session.createQuery("Select ur from UserRole ur where  ur.id.userId = :userId and ur.id.roleId in ( select r.id from Role r where r.id in :roleIds and r.inactive = false and r.systemDefault = 0)").setParameterList("roleIds", roleIds).setParameter("userId", (Object)userId).list();
                if (rolesToDelete.isEmpty()) {
                    status = "Nothing to delete. Either the role(s) are not present or the role(s) provided can't be deleted.";
                }
                for (UserRole r : rolesToDelete) {
                    System.out.println("Deleting role " + String.valueOf(r.getId().getRoleId()));
                    session.delete((Object)r);
                }
                tr.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return status;
    }

    public static void createApplicationRole(AppUser appUser, RolePrivilegeModel rpm) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        Org org = (Org)session.get(Org.class, (Serializable)((Object)appUser.getOrgId()));
        try {
            try {
                List privileges = session.createQuery("from Privilege p where p.id in :privileges order by p.privilege asc").setParameterList("privileges", rpm.getPrivileges()).list();
                List r = session.createQuery("from Role r where r.roleName = :rName").setParameter("rName", (Object)rpm.getRoleName()).list();
                System.out.println("Privileges to be added " + privileges.size());
                Role role = new Role();
                role.setTags(rpm.getTags());
                role.setRoleName(rpm.getRoleName().trim().toUpperCase());
                role.setRoleDescription(rpm.getRoleDescription());
                role.setCreatedBy(appUser.getId());
                role.setDateCreated(new Timestamp(new Date().getTime()));
                role.setInactive(false);
                role.setSystemDefault(false);
                role.setOrgType(org.getType());
                role.setOrgId(appUser.getOrgId());
                Integer id = (Integer)session.save((Object)role);
                HashSet<RolePrivilege> rolePrivileges = new HashSet<RolePrivilege>();
                for (Privilege priv : privileges) {
                    RolePrivilege rp = new RolePrivilege();
                    RolePrivilegeId rpId = new RolePrivilegeId();
                    rpId.setPrivilegeId(priv.getId());
                    rpId.setRoleId(id);
                    rp.setId(rpId);
                    rp.setCreatedBy(appUser.getId());
                    rp.setDateCreated(new Timestamp(new Date().getTime()));
                    rp.setInactive(false);
                    rp.setRole(role);
                    rp.setOrgId(appUser.getOrgId());
                    session.save((Object)rp);
                    rolePrivileges.add(rp);
                }
                role.setRolePrivileges(rolePrivileges);
                tr.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static void updateApplicationRole(AppUser appUser, UpdateRolePrivilegeModel rpm) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        try {
            try {
                Role role = (Role)session.find(Role.class, (Object)rpm.getRoleId());
                role.setRoleDescription(rpm.getRoleDescription());
                role.setRoleName(rpm.getRoleName());
                role.setTags(rpm.getTags());
                HashSet<RolePrivilege> rolePrivileges = new HashSet<RolePrivilege>();
                role.getRolePrivileges().clear();
                for (Integer privId : rpm.getPrivileges()) {
                    RolePrivilege rp = new RolePrivilege();
                    RolePrivilegeId rpId = new RolePrivilegeId();
                    rpId.setPrivilegeId(privId);
                    rpId.setRoleId(role.getId());
                    rp.setId(rpId);
                    rp.setCreatedBy(appUser.getId());
                    rp.setDateCreated(new Timestamp(new Date().getTime()));
                    rp.setInactive(false);
                    rp.setOrgId(appUser.getOrgId());
                    role.addPrivilege(rp);
                    rolePrivileges.add(rp);
                }
                session.merge((Object)role);
                tr.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static void deleteApplicationRole(AppUser appUser, String roleName) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        try {
            try {
                List roles = session.createQuery("from Role r where upper(r.roleName) =:roleName and r.orgId =:orgId").setParameter("orgId", (Object)appUser.getOrgId()).setParameter("roleName", (Object)roleName).list();
                if (roles.isEmpty()) {
                    throw new AppException("That role with the name " + roleName + " doesn't exists!");
                }
                for (Role role : roles) {
                    session.delete((Object)role);
                }
                tr.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static List<Privilege> getPrivileges(AppUser appUser) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        ArrayList<Privilege> privileges = new ArrayList();
        Set<String> roles = appUser.getRoles();
        List rolesS = roles.stream().collect(Collectors.toList());
        try {
            try {
                privileges = session.createQuery("from Privilege p where p.group LIKE (:types) ORDER BY p.privilege ASC").setParameter("types", (Object)("%" + appUser.getUserType() + "%")).list();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return privileges;
    }

    public static User getUser(String emailId) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        User user = new User();
        try (Session session = sf.openSession();){
            try {
                user = (User)session.createQuery("from User u where u.emailId = :emailId").setParameter("emailId", (Object)emailId).getSingleResult();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return user;
    }

    public static UserModel getUserByMobileNumber(String mobileNumber) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        User user = new User();
        UserModel userModel = new UserModel();
        try {
            try {
                user = (User)session.createQuery("from User u where u.mobilePhone = :mobileNumber", User.class).setParameter("mobileNumber", (Object)mobileNumber).getSingleResult();
                userModel = DBUtil.convertUserToUserModel(user);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return userModel;
    }

    public static User getUserById(String userId) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        User user = new User();
        try (Session session = sf.openSession();){
            try {
                user = (User)session.createQuery("from User u where u.id = :userId").setParameter("userId", (Object)userId).getSingleResult();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return user;
    }

    public static JSONObject getUsers(AppUser appUser, Integer rowNum, Integer size, String filter) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        ArrayList<UserModel> usersM = new ArrayList<UserModel>();
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("SUPERADMIN");
        roles.add("ADMIN");
        List users = null;
        try {
            long total = 0L;
            JSONObject pagedResponse = new JSONObject();
            pagedResponse.put((Object)"rowNum", (Object)rowNum);
            filter = filter == null || ((String)filter).isEmpty() ? "%" : "%" + (String)filter + "%";
            if (appUser.getRoles().contains("SUPERADMIN") || appUser.getRoles().contains("ADMIN")) {
                users = session.createQuery("from User u where (firstName like :filter or lastName like :filter) order by firstName asc").setParameter("filter", filter).setFirstResult(rowNum.intValue()).setMaxResults(size.intValue()).list();
                countQ = "Select count (id) from User u where (firstName like :filter or lastName like :filter)";
                countQuery = session.createQuery(countQ, Long.class).setParameter("filter", filter);
                total = (Long)countQuery.uniqueResult();
            } else {
                users = session.createQuery("from User u where u.systemDefault = false and u.orgId = :orgId and (firstName like :filter or lastName like :filter) order by firstName asc").setParameter("orgId", (Object)appUser.getOrgId()).setParameter("filter", filter).setFirstResult(rowNum.intValue()).setMaxResults(size.intValue()).list();
                countQ = "Select count (id) from User u where u.systemDefault = false and u.orgId = :orgId and (firstName like :filter or lastName like :filter)";
                countQuery = session.createQuery(countQ, Long.class).setParameter("orgId", (Object)appUser.getOrgId()).setParameter("filter", filter);
                total = (Long)countQuery.uniqueResult();
            }
            for (User user : users) {
                UserModel um = DBUtil.convertUserToUserModel(user);
                usersM.add(um);
            }
            String x = mapper.writeValueAsString(usersM);
            JsonNode responseList = mapper.readTree(x);
            pagedResponse.put((Object)"size", (Object)usersM.size());
            pagedResponse.put((Object)"total", (Object)total);
            pagedResponse.put((Object)"result", (Object)responseList);
            JSONObject jSONObject = pagedResponse;
            return jSONObject;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static List<UserModel> getUsersByOrgId(String orgId, Integer rowNum, Integer size) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        ArrayList<UserModel> usersM = new ArrayList<UserModel>();
        try (Session session = sf.openSession();){
            try {
                List users = session.createQuery("from User u where u.systemDefault = false and u.orgId = :orgId").setParameter("orgId", (Object)orgId).setFirstResult(rowNum.intValue()).setMaxResults(size.intValue()).list();
                for (User user : users) {
                    UserModel um = DBUtil.convertUserToUserModel(user);
                    usersM.add(um);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return usersM;
    }

    public static List<UserModel> searchUsers(AppUser appUser, List<String> roles) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        ArrayList<UserModel> usersM = new ArrayList<UserModel>();
        List users = null;
        try {
            try {
                users = session.createQuery("select u from User u, UserRole ur, Role r  where u.id = ur.id.userId and ur.id.roleId = r.id and u.orgId = :orgId and (r.roleName in :roleName or r.tags in :tags)").setParameter("orgId", (Object)appUser.getOrgId()).setParameterList("roleName", roles).setParameterList("tags", roles).list();
                for (User user : users) {
                    UserModel um = DBUtil.convertUserToUserModel(user);
                    usersM.add(um);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return usersM;
    }

    public static List<UserModel> getUsersByRoles(AppUser appUser, List<String> roles) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        ArrayList<UserModel> usersM = new ArrayList<UserModel>();
        List users = null;
        try {
            try {
                users = session.createQuery("select u from User u, UserRole ur, Role r  where u.id = ur.id.userId and ur.id.roleId = r.id and (r.roleName in :roleName)").setParameterList("roleName", roles).list();
                for (User user : users) {
                    UserModel um = DBUtil.convertUserToUserModel(user);
                    usersM.add(um);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return usersM;
    }

    public static UserModel getUserForAdmin(String userId) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        UserModel userM = null;
        try (Session session = sf.openSession();){
            try {
                User user = (User)session.get(User.class, (Serializable)((Object)userId));
                userM = DBUtil.convertUserToUserModel(user);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return userM;
    }

    public static UserModel getUserDetails(AppUser appUser) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        UserModel userM = null;
        try (Session session = sf.openSession();){
            try {
                User user = (User)session.get(User.class, (Serializable)((Object)appUser.getId()));
                userM = DBUtil.convertUserToUserModel(user);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return userM;
    }

    public static void forgotPassword(PasswordRequest pr) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        System.out.println("Pin " + pr.getPin());
        try (Session session = sf.openSession();){
            try {
                String email = pr.getEmail();
                String pin = pr.getPin();
                User user = (User)session.createQuery("from User u where u.emailId = :email and u.pinNumber =:pin").setParameter("email", (Object)email).setParameter("pin", (Object)pin).getSingleResult();
                if (user != null) {
                    Transaction tr = session.beginTransaction();
                    String passwd = DBUtil.getMd5(pr.getPassword());
                    user.setPasswd(passwd);
                    user.setInactive(false);
                    session.update((Object)user);
                    user.setTries(0);
                    tr.commit();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
    }

    public static AppUser updateUserDetails(AppUser appUser, UserModel user) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        User usr = null;
        try {
            usr = (User)session.get(User.class, (Serializable)((Object)user.getId()));
            usr.setFirstName(user.getFirstName());
            usr.setLastName(user.getLastName());
            usr.setLandline(user.getLandline());
            usr.setAddress(user.getAddress());
            usr.setCity(user.getCity());
            usr.setState(user.getState());
            usr.setZip(user.getZip());
            usr.setCountry(user.getCountry());
            usr.setCreatedBy(appUser.getId());
            usr.setDateCreated(new Date());
            usr.setInactive(user.getInactive());
            usr.setLandingPage(user.getLandingPage());
            session.update((Object)usr);
            tr.commit();
            AppUser appUser2 = DBUtil.getAppUser(usr.getEmailId());
            return appUser2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static String inactivateUser(AppUser appUser, String userId) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        User usr = null;
        try {
            usr = (User)session.get(User.class, (Serializable)((Object)userId));
            usr.setInactive(true);
            session.update((Object)usr);
            tr.commit();
            return "User Deleted!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static PartnerType createPartnerType(AppUser app, PartnerType partnerType) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        try {
            try {
                session.save((Object)partnerType);
                tr.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return partnerType;
    }

    public static List<PartnerType> getPartnerTypes(Integer rowNum, Integer size) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        ArrayList<PartnerType> partnerTypes = new ArrayList();
        try (Session session = sf.openSession();){
            try {
                partnerTypes = session.createQuery("from PartnerType pt").setFirstResult(rowNum.intValue()).setMaxResults(size.intValue()).list();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return partnerTypes;
    }

    public static OrgModel createOrg(AppUser appUser, OrgModel org) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        Org o = new Org();
        try {
            try {
                UUID uuid = UUID.randomUUID();
                UUID apiKey = UUID.nameUUIDFromBytes(org.getName().getBytes());
                String noDuplicates = Arrays.asList(org.getDefaultRole().split(";")).stream().distinct().collect(Collectors.joining(";"));
                org.setDefaultRole(noDuplicates);
                Object[] roleNames = org.getDefaultRole().split(";");
                List roles = session.createQuery("from Role r where r.roleName in :roleNames").setParameterList("roleNames", roleNames).list();
                List partnerTypes = session.createQuery("from PartnerType pt where pt.type = :type and pt.subType = :subType").setParameter("type", (Object)org.getType()).setParameter("subType", (Object)org.getSubType()).list();
                Org userOrg = null;
                Company company = null;
                if (appUser == null) {
                    company = (Company)session.createQuery("from Company c where c.primaryCompany = :primaryCompany").setParameter("primaryCompany", (Object)true).getSingleResult();
                    userOrg = (Org)session.createQuery("from Org c where c.primaryOrg =:primaryOrg").setParameter("primaryOrg", (Object)true).getSingleResult();
                } else {
                    userOrg = (Org)session.get(Org.class, (Serializable)((Object)appUser.getOrgId()));
                    company = userOrg.getCompany();
                }
                if (partnerTypes.isEmpty()) {
                    throw new AppException("The provided partner type: " + org.getType() + " and detail: " + org.getSubType() + " doesn't exist!");
                }
                if (roles.isEmpty()) {
                    throw new AppException("The provided role " + org.getDefaultRole() + " doesn't exist!");
                }
                o.setName(org.getName());
                o.setAddLine1(org.getAddLine1());
                o.setAddLine2(org.getAddLine2());
                o.setApiEnabled(false);
                o.setCity(org.getCity());
                o.setDefaultOrg(false);
                o.setContactNos(org.getContactNos());
                o.setCountry(org.getCountry());
                o.setMobilePhone(org.getMobileNumber());
                o.setWhatsappEnabled(org.isWhatsappEnabled());
                if (appUser == null) {
                    o.setCreatedBy("d1668e13-fc12-46c1-96db-18ba7e769103");
                } else {
                    o.setCreatedBy(appUser.getCreatedBy());
                }
                Timestamp ts = new Timestamp(new Date().getTime());
                o.setDateCreated(ts);
                o.setDeleted(false);
                o.setEmail(org.getEmail());
                o.setFirstName(org.getFirstName());
                o.setLastName(org.getLastName());
                o.setId(uuid.toString());
                o.setState(org.getState());
                o.setWebsite(org.getWebsite());
                o.setZipcode(org.getZipcode());
                o.setType(org.getType());
                o.setSubType(org.getSubType());
                o.setDefaultRole(org.getDefaultRole());
                o.setPrimaryOrg(false);
                o.setCompany(company);
                o.setRegistrationStatus("PENDING");
                o.setApiKey(apiKey.toString());
                o.setApiEnabled(true);
                User usr = new User();
                usr.setAddress(org.getAddLine1());
                usr.setCity(org.getCity());
                usr.setCountry(org.getCountry());
                usr.setEmailId(org.getEmail());
                usr.setFirstName(org.getFirstName());
                usr.setLastName(org.getLastName());
                usr.setLoginTries(0);
                usr.setMobilePhone(org.getMobileNumber());
                usr.setState(org.getState());
                usr.setSystemDefault(false);
                usr.setUserName(org.getEmail());
                usr.setZip(org.getZipcode());
                usr.setUserType(org.getDefaultRole());
                UUID uuidUser = UUID.randomUUID();
                usr.setId(uuidUser.toString());
                usr.setInactive(true);
                usr.setOrgId(o.getId());
                usr.setTries(0);
                usr.setLoginTries(0);
                usr.setLandingPage(org.getLandingPage());
                usr.setPasswd(DBUtil.getMd5(org.getPasswd()));
                boolean emailSent = false;
                try {
                    EmailUtil.sendRegistrationEmail(usr);
                    emailSent = true;
                }
                catch (Exception emx) {
                    emx.printStackTrace();
                }
                o.setEmailSent(emailSent);
                usr.setEmailSent(emailSent);
                session.save((Object)o);
                session.save((Object)usr);
                org.setId(o.getId());
                DBUtil.addUserRoles(usr, session);
                tr.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return org;
    }

    public static void saveOrgUserDBModel(Org o, User usr, Session session) {
        session.save((Object)o);
        session.save((Object)usr);
    }

    public static OrgUserDBModel createOrgUserDBModel(AppUser appUser, OrgModel org, Session session) throws Exception {
        Org o = new Org();
        UUID uuid = UUID.randomUUID();
        UUID apiKey = UUID.nameUUIDFromBytes(org.getName().getBytes());
        String noDuplicates = Arrays.asList(org.getDefaultRole().split(";")).stream().distinct().collect(Collectors.joining(";"));
        org.setDefaultRole(noDuplicates);
        Object[] roleNames = org.getDefaultRole().split(";");
        List roles = session.createQuery("from Role r where r.roleName in :roleNames").setParameterList("roleNames", roleNames).list();
        List partnerTypes = session.createQuery("from PartnerType pt where pt.type = :type and pt.subType = :subType").setParameter("type", (Object)org.getType()).setParameter("subType", (Object)org.getSubType()).list();
        Org userOrg = null;
        Company company = null;
        if (appUser == null) {
            company = (Company)session.createQuery("from Company c where c.primaryCompany = :primaryCompany").setParameter("primaryCompany", (Object)true).getSingleResult();
            userOrg = (Org)session.createQuery("from Org c where c.primaryOrg =:primaryOrg").setParameter("primaryOrg", (Object)true).getSingleResult();
        } else {
            userOrg = (Org)session.get(Org.class, (Serializable)((Object)appUser.getOrgId()));
            company = userOrg.getCompany();
        }
        if (partnerTypes.isEmpty()) {
            throw new AppException("The provided partner type: " + org.getType() + " and detail: " + org.getSubType() + " doesn't exist!");
        }
        if (roles.isEmpty()) {
            throw new AppException("The provided role " + org.getDefaultRole() + " doesn't exist!");
        }
        o.setName(org.getName());
        o.setAddLine1(org.getAddLine1());
        o.setAddLine2(org.getAddLine2());
        o.setApiEnabled(false);
        o.setCity(org.getCity());
        o.setDefaultOrg(false);
        o.setContactNos(org.getContactNos());
        o.setCountry(org.getCountry());
        o.setMobilePhone(org.getMobileNumber());
        o.setWhatsappEnabled(org.isWhatsappEnabled());
        if (appUser == null) {
            o.setCreatedBy("d1668e13-fc12-46c1-96db-18ba7e769103");
        } else {
            o.setCreatedBy(appUser.getCreatedBy());
        }
        Timestamp ts = new Timestamp(new Date().getTime());
        o.setDateCreated(ts);
        o.setDeleted(false);
        o.setEmail(org.getEmail());
        o.setFirstName(org.getFirstName());
        o.setLastName(org.getLastName());
        o.setId(uuid.toString());
        o.setState(org.getState());
        o.setWebsite(org.getWebsite());
        o.setZipcode(org.getZipcode());
        o.setType(org.getType());
        o.setSubType(org.getSubType());
        o.setDefaultRole(org.getDefaultRole());
        o.setPrimaryOrg(false);
        o.setCompany(company);
        o.setRegistrationStatus("PENDING");
        o.setApiKey(apiKey.toString());
        o.setApiEnabled(true);
        User usr = new User();
        usr.setAddress(org.getAddLine1());
        usr.setCity(org.getCity());
        usr.setCountry(org.getCountry());
        usr.setEmailId(org.getEmail());
        usr.setFirstName(org.getFirstName());
        usr.setLastName(org.getLastName());
        usr.setLoginTries(0);
        usr.setMobilePhone(org.getMobileNumber());
        usr.setState(org.getState());
        usr.setSystemDefault(false);
        usr.setUserName(org.getEmail());
        usr.setZip(org.getZipcode());
        usr.setUserType(org.getDefaultRole());
        UUID uuidUser = UUID.randomUUID();
        usr.setId(uuidUser.toString());
        usr.setInactive(true);
        usr.setOrgId(o.getId());
        usr.setTries(0);
        usr.setLoginTries(0);
        usr.setLandingPage(org.getLandingPage());
        usr.setPasswd(DBUtil.getMd5(org.getPasswd()));
        org.setId(o.getId());
        DBUtil.addUserRoles(usr, session);
        OrgUserDBModel oudm = new OrgUserDBModel();
        oudm.setO(o);
        oudm.setUsr(usr);
        return oudm;
    }

    public static Org getOrgByName(String orgName) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Org org = null;
        try (Session session = sf.openSession();){
            try {
                org = (Org)session.createQuery("from Org o where o.name =:orgName").setParameter("orgName", (Object)orgName).setMaxResults(1).getSingleResult();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return org;
    }

    public static List<Org> getOrgs(AppUser user, Integer rowNum, Integer size) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        List orgs = null;
        try (Session session = sf.openSession();){
            try {
                Org org = (Org)session.get(Org.class, (Serializable)((Object)user.getOrgId()));
                orgs = session.createQuery("from Org o where o.company.id =:companyId").setParameter("companyId", (Object)org.getCompany().getId()).setFirstResult(rowNum.intValue()).setMaxResults(size.intValue()).list();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return orgs;
    }

    public static OrgModel updateOrg(AppUser appUser, OrgModel org) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        Org o = null;
        try {
            try {
                Org userOrg = (Org)session.get(Org.class, (Serializable)((Object)appUser.getOrgId()));
                Company company = userOrg.getCompany();
                o = (Org)session.get(Org.class, (Serializable)((Object)org.getId()));
                o.setName(org.getName());
                o.setAddLine1(org.getAddLine1());
                o.setAddLine2(org.getAddLine2());
                o.setApiEnabled(false);
                o.setDefaultOrg(false);
                o.setCity(org.getCity());
                o.setContactNos(org.getContactNos());
                o.setCountry(org.getCountry());
                o.setCreatedBy(appUser.getCreatedBy());
                Timestamp ts = new Timestamp(new Date().getTime());
                o.setDateCreated(ts);
                o.setDeleted(false);
                o.setEmail(org.getEmail());
                o.setFirstName(org.getFirstName());
                o.setLastName(org.getLastName());
                o.setState(org.getState());
                o.setWebsite(org.getWebsite());
                o.setZipcode(org.getZipcode());
                o.setCompany(company);
                o.setRegistrationStatus(org.getRegistrationStatus());
                o.setMobilePhone(org.getMobileNumber());
                o.setWhatsappEnabled(org.isWhatsappEnabled());
                session.update((Object)o);
                tr.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return org;
    }

    public static List<Org> getOrgs(String companyId, Integer rowNum, Integer size) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        List orgs = null;
        try (Session session = sf.openSession();){
            try {
                orgs = session.createQuery("from Org o where o.company.id =:companyId").setParameter("companyId", (Object)companyId).setFirstResult(rowNum.intValue()).setMaxResults(size.intValue()).list();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return orgs;
    }

    public static OrgDetailModel addOrgDetail(OrgDetailModel model, String orgId) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        try {
            Org org = (Org)session.get(Org.class, (Serializable)((Object)orgId));
            model.setId(UUID.randomUUID().toString());
            OrgDetail orgDetail = new OrgDetail();
            orgDetail.setId(model.getId());
            orgDetail.setFieldCategory(model.getFieldCategory());
            orgDetail.setFieldName(model.getFieldName());
            orgDetail.setFieldType(model.getFieldType());
            orgDetail.setFieldValue(model.getFieldValue());
            orgDetail.setInfo(model.getInfo());
            orgDetail.setOrg(org);
            session.save((Object)orgDetail);
            tr.commit();
            OrgDetailModel orgDetailModel = model;
            return orgDetailModel;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static OrgDetailModel updateOrgDetail(OrgDetailModel model) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        try {
            OrgDetail orgDetail = (OrgDetail)session.get(OrgDetail.class, (Serializable)((Object)model.getId()));
            orgDetail.setFieldCategory(model.getFieldCategory());
            orgDetail.setFieldName(model.getFieldName());
            orgDetail.setFieldType(model.getFieldType());
            orgDetail.setFieldValue(model.getFieldValue());
            orgDetail.setInfo(model.getInfo());
            session.update((Object)orgDetail);
            tr.commit();
            OrgDetailModel orgDetailModel = model;
            return orgDetailModel;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static void deleteOrgDetail(String orgDetailId) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        try {
            try {
                OrgDetail orgDetail = (OrgDetail)session.get(OrgDetail.class, (Serializable)((Object)orgDetailId));
                session.delete((Object)orgDetail);
                tr.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static Set<OrgDetail> getOrgDetails(String orgId) {
        Org o = DBUtil.getOrgById(orgId);
        return o.getOrgDetails();
    }

    public static String getPin(PasswordRequest passwordRequest) throws Exception {
        String pin;
        block7: {
            SessionFactory sf = HibernateUtil.getSessionFactory();
            Session session = sf.openSession();
            pin = EmailUtil.emailPin();
            Properties props = FileUtil.getProperties();
            Integer tries = Integer.parseInt(props.getProperty("user.tries"));
            System.out.println("Email pin " + pin + " to " + passwordRequest.getEmail() + "  User max tries " + String.valueOf(tries));
            try {
                try {
                    User user = (User)session.createQuery("from User u where u.emailId = :email").setParameter("email", (Object)passwordRequest.getEmail()).getSingleResult();
                    if (user != null && user.getTries() <= tries) {
                        Transaction tr = session.beginTransaction();
                        user.setPinNumber(pin);
                        user.setTries(user.getTries() + 1);
                        session.update((Object)user);
                        tr.commit();
                        EmailUtil.sendPin(user.getEmailId(), user.getPinNumber());
                        break block7;
                    }
                    if (user != null) {
                        throw new Exception("You have exceeded your tries. Please contact the administrator.");
                    }
                    throw new Exception("User " + passwordRequest.getEmail() + ". Not found");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw ex;
                }
            }
            finally {
                session.close();
            }
        }
        return pin;
    }

    public static String getMd5(String input) throws Exception {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            BigInteger no = new BigInteger(1, messageDigest);
            Object hashtext = no.toString(16);
            while (((String)hashtext).length() < 32) {
                hashtext = "0" + (String)hashtext;
            }
            return hashtext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static void saveFile(InputStream file, String name) {
        try {
            Path path = FileSystems.getDefault().getPath(name, new String[0]);
            Files.copy(file, path, new CopyOption[0]);
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    private static void deleteFile(String name) {
        try {
            Path path = FileSystems.getDefault().getPath(name, new String[0]);
            Files.deleteIfExists(path);
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    public static void profileUser(String str) {
    }

    public static void printSQLException(SQLException ex) {
        for (Throwable e : ex) {
            if (!(e instanceof SQLException) || DBUtil.ignoreSQLException(((SQLException)e).getSQLState())) continue;
            e.printStackTrace(System.err);
            System.err.println("SQLState: " + ((SQLException)e).getSQLState());
            System.err.println("Error Code: " + ((SQLException)e).getErrorCode());
            System.err.println("Message: " + e.getMessage());
            Throwable t = ex.getCause();
            while (t != null) {
                System.out.println("Cause: " + String.valueOf(t));
                t = t.getCause();
            }
        }
    }

    public static boolean ignoreSQLException(String sqlState) {
        if (sqlState == null) {
            System.out.println("The SQL state is not defined!");
            return false;
        }
        if (sqlState.equalsIgnoreCase("X0Y32")) {
            return true;
        }
        return sqlState.equalsIgnoreCase("42Y55");
    }

    public static UserModel convertUserToUserModel(User user) {
        UserModel um = new UserModel();
        um.setAddress(user.getAddress());
        um.setCity(user.getCity());
        um.setColor(user.getColor());
        um.setCountry(user.getCountry());
        um.setEmailId(user.getEmailId());
        um.setFirstName(user.getFirstName());
        um.setLastName(user.getLastName());
        um.setLandline(user.getLandline());
        um.setMobilePhone(user.getMobilePhone());
        um.setState(user.getState());
        um.setUserName(user.getUserName());
        um.setZip(user.getZip());
        um.setUserType(user.getUserType());
        um.setId(user.getId());
        um.setInactive(user.isInactive());
        um.setPasswd("##########");
        um.setOrgId(user.getOrgId());
        um.setLandingPage(user.getLandingPage());
        return um;
    }

    public static void setOtp(String mobile, String pin) throws Exception {
        block6: {
            SessionFactory sf = HibernateUtil.getSessionFactory();
            try (Session session = sf.openSession();){
                try {
                    User user = (User)session.createQuery("from User u where u.mobilePhone = :mobile").setParameter("mobile", (Object)mobile).getSingleResult();
                    if (user != null) {
                        Transaction tr = session.beginTransaction();
                        user.setPinNumber(pin);
                        session.update((Object)user);
                        tr.commit();
                        break block6;
                    }
                    throw new Exception("User with the # " + mobile + ". Not found!");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw ex;
                }
            }
        }
    }

    public static AppUser verifyOtp(String mobile, String pin) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        try (Session session = sf.openSession();){
            User user = (User)session.createQuery("from User u where u.mobilePhone = :mobile").setParameter("mobile", (Object)mobile).getSingleResult();
            if (user != null && user.getPinNumber().equals(pin)) {
                AppUser appUser = DBUtil.getAppUser(user.getEmailId());
                return appUser;
            }
            try {
                throw new Exception("Invalid pin or User with the # " + mobile + ". Not found!");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
    }

    public static String sentOtp(String mobile) throws Exception {
        String template;
        Properties props = FileUtil.getProperties();
        String otpUrl = props.getProperty("otpUrl");
        String otpSender = props.getProperty("otpSender");
        String otpAuthKey = props.getProperty("otpAuthKey");
        String otpTemplateId = props.getProperty("otpTemplateId");
        String otpRoute = props.getProperty("otpRoute");
        String otpMessage = props.getProperty("otpMessage");
        Random rand = new Random();
        String otp = String.format("%04d", rand.nextInt(10000));
        DBUtil.setOtp(mobile, otp);
        System.out.println("OTP " + otp);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("otp", otp);
        String message = template = StringSubstitutor.replace((Object)otpMessage, params, (String)"${", (String)"}");
        message = URLEncoder.encode(message, StandardCharsets.UTF_8.toString());
        System.out.println(message);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(otpUrl + "?authkey=" + otpAuthKey + "&mobiles=" + mobile + "&message=" + message + "&sender=" + otpSender + "&otp=" + otp + "&DLT_TE_ID=" + otpTemplateId + "&route=" + otpRoute + "&country=91&response=json")).GET().build();
        HttpResponse<String> response = HttpClient.newBuilder().proxy(ProxySelector.getDefault()).build().send(request, HttpResponse.BodyHandlers.ofString());
        System.out.println("Response " + response.body());
        return response.body();
    }

    public static Org getOrgById(String orgId) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Org org = null;
        try (Session session = sf.openSession();){
            try {
                org = (Org)session.get(Org.class, (Serializable)((Object)orgId));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return org;
    }

    public static User checkUserExists(UserModel userModel) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        User user = null;
        try (Session session = sf.openSession();){
            try {
                System.out.println("Finding with emailId " + userModel.getEmailId() + " and mobilePhone " + userModel.getMobilePhone());
                String query = "from User u where (u.emailId =:username or u.mobilePhone =:mobilePhone)";
                user = (User)session.createQuery(query).setParameter("username", (Object)userModel.getEmailId()).setParameter("mobilePhone", (Object)userModel.getMobilePhone()).setMaxResults(1).getSingleResult();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (session != null) {
                    session.close();
                }
            }
        }
        return user;
    }

    public static void setLandingPage(AppUser appUser, String url) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Transaction tr = session.beginTransaction();
        try {
            try {
                User user = DBUtil.getUserById(appUser.getId());
                user.setLandingPage(url);
                session.update((Object)user);
                tr.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static PartnerType getPartnerTypeById(long partnerTypeId) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        PartnerType partnerType = null;
        try (Session session = sf.openSession();){
            try {
                partnerType = (PartnerType)session.get(PartnerType.class, (Serializable)Long.valueOf(partnerTypeId));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return partnerType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<User> getUserListByPrivilege(AppUser appUser, String privilege, String nameStr) {
        if (nameStr == null) {
            nameStr = "";
        }
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        int privilegeId = 0;
        List users = null;
        try {
            try {
                Privilege p = (Privilege)session.createQuery("from Privilege where privilege =:privilege", Privilege.class).setParameter("privilege", (Object)privilege).getSingleResult();
                if (p != null) {
                    privilegeId = p.getId();
                }
                users = session.createNativeQuery("select * from `user` u where u.org_id =:orgId and (u.first_name like :nameStr or u.last_name like :nameStr) and u.id in (select ur.user_id from user_role ur where ur.role_id in (select rp.role_id from role_privilege rp where rp.privilege_id =:privilegeId))", User.class).setParameter("orgId", (Object)appUser.getOrgId()).setParameter("privilegeId", (Object)privilegeId).setParameter("nameStr", (Object)("%" + nameStr + "%")).list();
                return users;
            }
            catch (NoResultException ex) {
                ex.printStackTrace();
                if (session == null) return users;
                session.close();
                return users;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (session == null) return users;
                session.close();
                return users;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static DBStatsModel getDBStats() {
        SessionFactory sessionFactory = HibernateUtil.getSessionFactory();
        Statistics stats = sessionFactory.getStatistics();
        DBStatsModel dbStatsModel = new DBStatsModel();
        dbStatsModel.setConnectCount(stats.getConnectCount());
        dbStatsModel.setQueryExecutionCount(stats.getQueryExecutionCount());
        dbStatsModel.setQueryExecutionMaxTime(stats.getQueryExecutionMaxTime());
        dbStatsModel.setSessionCloseCount(stats.getSessionCloseCount());
        dbStatsModel.setSessionOpenCount(stats.getSessionOpenCount());
        dbStatsModel.setSuccessfulTransactionCount(stats.getSuccessfulTransactionCount());
        dbStatsModel.setTransactionCount(stats.getTransactionCount());
        dbStatsModel.setQueryExecutionMaxTimeQueryString(stats.getQueryExecutionMaxTimeQueryString());
        dbStatsModel.setQueries(stats.getQueries());
        stats.getQueries();
        return dbStatsModel;
    }

    public static void main(String[] args) {
        try {
            String droles = "HOSP_ADMIN_OFFICER;MOBILE_USER;MOBILE_USER;MOBILE_USER;MOBILE_USER;MOBILE_USER;MOBILE_USER;MOBILE_USER;MOBILE_USER";
            String noDuplicates = Arrays.asList(droles.split(";")).stream().distinct().collect(Collectors.joining(";"));
            System.out.println(noDuplicates);
            String[] temp = noDuplicates.split(";");
            System.out.println(temp.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getUserDisplayName(String userId) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        User user = null;
        Object name = "";
        try {
            try {
                user = (User)session.get(User.class, (Serializable)((Object)userId));
                if (user != null) {
                    name = user.getFirstName() + " " + user.getLastName();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return name;
    }

    public static String getOrgDisplayName(String orgId) {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        Session session = sf.openSession();
        Org o = null;
        String name = "";
        try {
            try {
                o = (Org)session.get(Org.class, (Serializable)((Object)orgId));
                if (o != null) {
                    name = o.getName();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return name;
    }

    public static List<Privilege> getRolePrivileges(AppUser appUser, int roleId) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        ArrayList<Privilege> privileges = new ArrayList();
        try (Session session = sf.openSession();){
            try {
                privileges = session.createQuery("select p from Privilege p, RolePrivilege rp, Role r where r.id = :roleId and rp.id.roleId =:roleId and rp.id.privilegeId = p.id ", Privilege.class).setParameter("roleId", (Object)roleId).list();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return privileges;
    }

    public static void addRolePrivileges(AppUser appUser, int roleId, int privilegeId) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        try (Session session = sf.openSession();){
            try {
                Transaction tx = session.beginTransaction();
                Role role = (Role)session.get(Role.class, (Serializable)Integer.valueOf(roleId));
                RolePrivilege rp = new RolePrivilege();
                RolePrivilegeId rpId = new RolePrivilegeId();
                rpId.setPrivilegeId(privilegeId);
                rpId.setRoleId(roleId);
                rp.setCreatedBy(appUser.getId());
                rp.setDateCreated(new Timestamp(new Date().getTime()));
                rp.setId(rpId);
                rp.setOrgId(appUser.getOrgId());
                rp.setRole(role);
                rp.setInactive(false);
                session.save((Object)rp);
                tx.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
    }

    public static void removeRolePrivileges(AppUser appUser, int roleId, int privilegeId) throws Exception {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        try (Session session = sf.openSession();){
            try {
                Transaction tx = session.beginTransaction();
                RolePrivilegeId rpId = new RolePrivilegeId();
                rpId.setPrivilegeId(privilegeId);
                rpId.setRoleId(roleId);
                RolePrivilege rp = (RolePrivilege)session.get(RolePrivilege.class, (Serializable)rpId);
                session.delete((Object)rp);
                tx.commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
    }
}

