/*
 * Decompiled with CFR 0.152.
 */
package com.biz.security.filter;

import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;

@PreMatching
public class CORSResponseFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public void filter(ContainerRequestContext request) throws IOException {
        if (CORSResponseFilter.isPreflightRequest(request)) {
            request.abortWith(Response.ok().build());
            return;
        }
    }

    private static boolean isPreflightRequest(ContainerRequestContext request) {
        return request.getHeaderString("Origin") != null && request.getMethod().equalsIgnoreCase("OPTIONS");
    }

    public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
        if (request.getHeaderString("Origin") == null) {
            return;
        }
        if (CORSResponseFilter.isPreflightRequest(request)) {
            response.getHeaders().add((Object)"Access-Control-Allow-Credentials", (Object)"true");
            response.getHeaders().add((Object)"Access-Control-Allow-Methods", (Object)"GET, POST, PUT, DELETE, PATCH, OPTIONS, HEAD");
            response.getHeaders().add((Object)"Access-Control-Allow-Headers", (Object)"X-Requested-With, Authorization, Accept-Version, Content-MD5, CSRF-Token, Content-Type");
        }
        response.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)"*");
    }
}

