/*
 * Decompiled with CFR 0.152.
 */
package com.biz.security.filter;

import com.auth0.jwt.interfaces.Claim;
import com.biz.security.configuration.ApplicationSecurityContext;
import com.biz.security.exception.AppException;
import com.biz.security.model.AppUser;
import com.biz.security.util.DBUtil;
import com.biz.security.util.FileUtil;
import com.biz.security.util.JWTUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.message.internal.ReaderWriter;

public class AuthenticationFilter
implements ContainerRequestFilter {
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Method method;
        String authorizationHeader = requestContext.getHeaderString("Authorization");
        String wcSignature = requestContext.getHeaderString("x-wc-webhook-signature");
        if (authorizationHeader != null && authorizationHeader.startsWith("Bearer ")) {
            String jwtToken = authorizationHeader.substring(7);
            try {
                JWTUtil jwtUtil = new JWTUtil();
                Claim privilegeClaim = jwtUtil.verifyToken(jwtToken);
                Claim userIdClaim = jwtUtil.getClaim(jwtToken, "userId");
                this.handleAuthorization(requestContext, privilegeClaim, userIdClaim);
            }
            catch (Exception e) {
                e.printStackTrace();
                Response.ResponseBuilder builder = null;
                String response = "You are not authorized to use this service";
                builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)response);
                throw new WebApplicationException(builder.build());
            }
            return;
        }
        if (wcSignature != null) {
            try {
                Properties prop = FileUtil.getProperties();
                String secret = prop.getProperty("wc.secret");
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                InputStream in = requestContext.getEntityStream();
                ReaderWriter.writeTo((InputStream)in, (OutputStream)out);
                byte[] requestEntity = out.toByteArray();
                requestContext.setEntityStream((InputStream)new ByteArrayInputStream(requestEntity));
                boolean isValid = JWTUtil.calcHmacSha256(secret.getBytes(), requestEntity, wcSignature);
                if (!isValid) {
                    throw new AppException("Content is modified!");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if ((method = this.resourceInfo.getResourceMethod()).isAnnotationPresent(PermitAll.class)) {
            return;
        }
    }

    public void handleAuthorization(ContainerRequestContext requestContext, Claim claim, Claim userIdClaim) throws Exception {
        Method method = this.resourceInfo.getResourceMethod();
        String[] privileges = (String[])claim.asArray(String.class);
        AppUser appUser = DBUtil.getAppUser(userIdClaim.asString());
        ApplicationSecurityContext appSecurityContext = new ApplicationSecurityContext(appUser, "Bearer", true);
        requestContext.setSecurityContext((SecurityContext)appSecurityContext);
        if (method.isAnnotationPresent(RolesAllowed.class)) {
            RolesAllowed rolesAnnotation = method.getAnnotation(RolesAllowed.class);
            HashSet<String> rolesSet = new HashSet<String>(Arrays.asList(rolesAnnotation.value()));
            int length = privileges.length;
            int b = 0;
            while (b < length) {
                String priv = privileges[b];
                if (rolesSet.contains(priv.toString())) {
                    return;
                }
                ++b;
            }
            throw new IOException("You don't have the privilege to access this service!");
        }
    }
}

