/*
 * Decompiled with CFR 0.152.
 */
package com.biz.security.configuration;

import com.biz.security.model.AppUser;
import java.security.Principal;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

@Provider
public class ApplicationSecurityContext
implements SecurityContext {
    private AppUser appUser;
    private String scheme;
    private boolean secure;

    public ApplicationSecurityContext(AppUser appUser, String scheme, boolean secure) {
        this.appUser = appUser;
        this.scheme = scheme;
        this.secure = secure;
    }

    public Principal getUserPrincipal() {
        return this.appUser;
    }

    public boolean isUserInRole(String role) {
        return this.appUser.getPrivileges().contains(role);
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getAuthenticationScheme() {
        return this.scheme;
    }
}

